package jamezo97.clonecraft.block;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.opengl.GL11;

public class TileEntityCentrifugeRenderer extends TileEntitySpecialRenderer{

	static RenderItem itemRenderer = new RenderItem();
	
	@Override
	public void renderTileEntityAt(TileEntity tileentity, double d0, double d1, double d2, float f) {
		this.renderCentrifuge((TileEntityCentrifuge)tileentity, d0, d1, d2, f);
	}

	public static void renderCentrifuge(TileEntityCentrifuge tec, double x, double y, double z, float f) {
		GL11.glPushMatrix();
		bindCentrifugeBlock();
		GL11.glDisable(GL11.GL_LIGHTING);
/*		Tessellator t = Tessellator.instance;
		t.setBrightness(983055);
		GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);*/
		GL11.glTranslated(x, y, z);
		renderBase();
		GL11.glTranslatef(.5f, .5f, .5f);
		GL11.glRotatef(tec != null?tec.getSpin(f):0, 0, 1, 0);
		GL11.glTranslatef(-.5f, -.5f, -.5f);
		renderSpin(tec);
		GL11.glEnable(GL11.GL_LIGHTING);
		GL11.glPopMatrix();
	}
	
	private static void renderSpin(TileEntityCentrifuge tec) {
		Tessellator t = Tessellator.instance;
		t.setColorRGBA(255, 255, 255, 255);
		t.setBrightness(145);
		//GL11.glDisable(GL11.GL_LIGHTING);
		drawPole(t);
		//GL11.glEnable(GL11.GL_LIGHTING);
		GL11.glDisable(GL11.GL_CULL_FACE);
		drawHoldersAndItems(t, tec);
		GL11.glEnable(GL11.GL_CULL_FACE);
	}
	
	public static void drawHoldersAndItems(Tessellator t, TileEntityCentrifuge tec){
		t.startDrawingQuads();
		t.addVertexWithUV(.125, .9375, .5625, .125, 0);
		t.addVertexWithUV(.875, .9375, .5625, .125, .875);
		t.addVertexWithUV(.875, .9375, .4375, 0, .875);
		t.addVertexWithUV(.125, .9375, .4375, 0, 0);
		t.draw();
		t.startDrawingQuads();
		t.addVertexWithUV(.5625, .9376, .875, .125, 0);
		t.addVertexWithUV(.5625, .9376, .125, .125, .875);
		t.addVertexWithUV(.4375, .9376, .125, 0, .875);
		t.addVertexWithUV(.4375, .9376, .875, 0, 0);
		t.draw();
		
		float angle = 0;
		ItemStack s1 = null, s2 = null, s3 = null, s4 = null;
		if(tec != null){
			angle = (tec.speed / ((float)tec.spinSpeedMax))*65f;
			s1 = tec.getStackInSlot(0);
			s2 = tec.getStackInSlot(1);
			s3 = tec.getStackInSlot(2);
			s4 = tec.getStackInSlot(3);
		}
		
		GL11.glPushMatrix();
		GL11.glTranslatef(.125f, .9375f, .5f);
		GL11.glRotatef(-angle, 0, 0, 1);
		t.startDrawingQuads();
		t.addVertexWithUV(0, 0, 0, 0, 0);
		t.addVertexWithUV(.0625, 0, 0, .0625, 0);
		t.addVertexWithUV(.0625, -.125, 0, .0625, .125);
		t.addVertexWithUV(0, -.125, 0, 0, .125);
		t.draw();
		if(s1 != null){
			GL11.glRotatef(90, 0, 1, 0);
			GL11.glScalef(.4f, .4f, .4f);
			GL11.glTranslatef(-.5f, -1.1f, .1f);
			renderItemstack(s1);
			bindCentrifugeBlock();
		}
		GL11.glPopMatrix();
		
		GL11.glPushMatrix();
		GL11.glTranslatef(.5f, .9375f, .875f);
		GL11.glRotatef(-angle, 1, 0, 0);
		t.startDrawingQuads();
		t.addVertexWithUV(0, 0, 0, 0, 0);
		t.addVertexWithUV(0, 0, -.0625, .0625, 0);
		t.addVertexWithUV(0, -.125, -.0625, .0625, .125);
		t.addVertexWithUV(0, -.125, 0, 0, .125);
		t.draw();
		if(s2 != null){
			GL11.glScalef(.4f, .4f, .4f);
			GL11.glTranslatef(-.5f, -1.1f, -.05f);
			renderItemstack(s2);
			bindCentrifugeBlock();
		}
		GL11.glPopMatrix();
		
		GL11.glPushMatrix();
		GL11.glTranslatef(.875f, .9375f, .5f);
		GL11.glRotatef(angle, 0, 0, 1);
		t.startDrawingQuads();
		t.addVertexWithUV(0, 0, 0, 0, 0);
		t.addVertexWithUV(-.0625, 0, 0, .0625, 0);
		t.addVertexWithUV(-.0625, -.125, 0, .0625, .125);
		t.addVertexWithUV(0, -.125, 0, 0, .125);
		t.draw();
		if(s3 != null){
			GL11.glRotatef(90, 0, 1, 0);
			GL11.glScalef(.4f, .4f, .4f);
			GL11.glTranslatef(-.5f, -1.1f, -.05f);
			renderItemstack(s3);
			bindCentrifugeBlock();
		}
		GL11.glPopMatrix();
		
		GL11.glPushMatrix();
		GL11.glTranslatef(.5f, .9375f, .125f);
		GL11.glRotatef(angle, 1, 0, 0);
		t.startDrawingQuads();
		t.addVertexWithUV(0, 0, 0, 0, 0);
		t.addVertexWithUV(0, 0, .0625, .0625, 0);
		t.addVertexWithUV(0, -.125, .0625, .0625, .125);
		t.addVertexWithUV(0, -.125, 0, 0, .125);
		t.draw();
		if(s4 != null){
			GL11.glScalef(.4f, .4f, .4f);
			GL11.glTranslatef(-.5f, -1.1f, .1f);
			renderItemstack(s4);
			bindCentrifugeBlock();
		}
		GL11.glPopMatrix();
	}
	
	public static void drawPole(Tessellator t){
		double top = .9375;
		
		
		t.startDrawingQuads();
		t.addVertexWithUV(.4375, top, .4375, .5, 0);
		t.addVertexWithUV(.5625, top, 0.4375, .625, 0);
		t.addVertexWithUV(.5625, .125, 0.4375, .625, .75);
		t.addVertexWithUV(.4375, .125, .4375, .5, .75);
		t.draw();
		t.startDrawingQuads();
		t.addVertexWithUV(.5625, top, 0.5625, .5, 0);
		t.addVertexWithUV(.4375, top, .5625, .625, 0);
		t.addVertexWithUV(.4375, .125, .5625, .625, .75);
		t.addVertexWithUV(.5625, .125, 0.5625, .5, .75);
		t.draw();

		t.startDrawingQuads();
		t.addVertexWithUV(.4375, top, .5625, .5, 0);
		t.addVertexWithUV(.4375, top, .4375, .625, 0);
		t.addVertexWithUV(.4375, .125, .4375, .625, .75);
		t.addVertexWithUV(.4375, .125, .5625, .5, .75);
		t.draw();
		t.startDrawingQuads();
		t.addVertexWithUV(.5625, top, .4375, .5, 0);
		t.addVertexWithUV(.5625, top, .5625, .625, 0);
		t.addVertexWithUV(.5625, .125, .5625, .625, .75);
		t.addVertexWithUV(.5625, .125, .4375, .5, .75);
		t.draw();
	}

	public static void renderBase(){
		Tessellator t = Tessellator.instance;
		drawEnds(t);
		drawTops(t);
		drawSides(t);
	}
	
	public static void drawSides(Tessellator t){
		t.startDrawingQuads();
		t.addVertexWithUV(.375, .125, 1, .125, 0);
		t.addVertexWithUV(.375, .125, 0, .125, 1);
		t.addVertexWithUV(.375, 0, 0, 0, 1);
		t.addVertexWithUV(.375, 0, 1, 0, 0);
		t.draw();
		t.startDrawingQuads();
		t.addVertexWithUV(.625, .125, 0, .125, 0);
		t.addVertexWithUV(.625, .125, 1, .125, 1);
		t.addVertexWithUV(.625, 0, 1, 0, 1);
		t.addVertexWithUV(.625, 0, 0, 0, 0);
		t.draw();
		
		
		t.startDrawingQuads();
		t.addVertexWithUV(0, .125, .375, .125, 0);
		t.addVertexWithUV(1, .125, .375, .125, 1);
		t.addVertexWithUV(1, 0, .375, 0, 1);
		t.addVertexWithUV(0, 0, .375, 0, 0);
		t.draw();
		t.startDrawingQuads();
		t.addVertexWithUV(1, .125, .625, .125, 0);
		t.addVertexWithUV(0, .125, .625, .125, 1);
		t.addVertexWithUV(0, 0, .625, 0, 1);
		t.addVertexWithUV(1, 0, .625, 0, 0);
		t.draw();
		
		

	}
	
	public static void drawTops(Tessellator t){
		t.startDrawingQuads();
		t.addVertexWithUV(.375, .125, 0, 0, 1);
		t.addVertexWithUV(.375, .125, 1, 0, 0);
		t.addVertexWithUV(.625, .125, 1, .25, 0);
		t.addVertexWithUV(.625, .125, 0, .25, 1);
		t.draw();
		t.startDrawingQuads();
		t.addVertexWithUV(0, .125, .625, .25, 1);
		t.addVertexWithUV(1, .125, .625, .25, 0);
		t.addVertexWithUV(1, .125, .375, .5, 0);
		t.addVertexWithUV(0, .125, .375, .5, 1);
		t.draw();
		
		t.startDrawingQuads();
		t.addVertexWithUV(.375, 0, 1, 0, 1);
		t.addVertexWithUV(.375, 0, 0, 0, 0);
		t.addVertexWithUV(.625, 0, 0, .25, 0);
		t.addVertexWithUV(.625, 0, 1, .25, 1);
		t.draw();
		t.startDrawingQuads();
		t.addVertexWithUV(1, 0, .625, .25, 1);
		t.addVertexWithUV(0, 0, .625, .25, 0);
		t.addVertexWithUV(0, 0, .375, .5, 0);
		t.addVertexWithUV(1, 0, .375, .5, 1);

		t.draw();
	}
	
	public static void drawEnds(Tessellator t){
		t.startDrawingQuads();
		t.addVertexWithUV(.375, 0, 0, 0, 1);
		t.addVertexWithUV(.375, .125, 0, 0, .875);
		t.addVertexWithUV(.625, .125, 0, .25, .875);
		t.addVertexWithUV(.625, 0, 0, .25, 1);
		t.draw();
		t.startDrawingQuads();
		t.addVertexWithUV(.375, .125, 1, 0, 1);
		t.addVertexWithUV(.375, 0, 1, 0, .875);
		t.addVertexWithUV(.625, 0, 1, .25, .875);
		t.addVertexWithUV(.625, .125, 1, .25, 1);
		t.draw();
		
		t.startDrawingQuads();
		t.addVertexWithUV(1, 0, .375, 0, 1);
		t.addVertexWithUV(1, .125, .375, 0, .875);
		t.addVertexWithUV(1, .125, .625, .25, .875);
		t.addVertexWithUV(1, 0, .625, .25, 1);
		t.draw();
		t.startDrawingQuads();
		t.addVertexWithUV(0, .125, .375, 0, 1);
		t.addVertexWithUV(0, 0, .375, 0, .875);
		t.addVertexWithUV(0, 0, .625, .25, .875);
		t.addVertexWithUV(0, .125, .625, .25, 1);
		t.draw();
	}
	static RenderItem ri = new RenderItem();
	public static void renderItemstack(ItemStack stack){
		RenderManager renderManager = RenderManager.instance;
		TextureManager texturemanager = Minecraft.getMinecraft().getTextureManager();
		for(int a = 0; a < stack.getItem().getRenderPasses(stack.getItemDamage()); a++){
			Icon par2Icon = stack.getItem().getIcon(stack, a);
	        float f4 = par2Icon.getMinU();
	        float f5 = par2Icon.getMaxU();
	        float f6 = par2Icon.getMinV();
	        float f7 = par2Icon.getMaxV();

	        GL11.glPushMatrix();
	        float f12 = 0.0625F;
            texturemanager.bindTexture(texturemanager.getResourceLocation(stack.getItemSpriteNumber()));
	        int colour = stack.getItem().getColorFromItemStack(stack, a);
	        int red = (colour >> 16) & 0xff;
	        int green = (colour >> 8) & 0xff;
	        int blue = colour & 0xff;
	        float redF = ((float)red)/255.0f;
	        float greenF = ((float)green)/255.0f;
	        float blueF = ((float)blue)/255.0f;
	        GL11.glColor4f(redF, greenF, blueF, 1.0f);
	        ItemRenderer.renderItemIn2D(Tessellator.instance, f5, f6, f4, f7, par2Icon.getIconWidth(), par2Icon.getIconHeight(), f12);
	        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
	        GL11.glPopMatrix();
		}
	}
	static ResourceLocation resource = new ResourceLocation("CloneCraft:textures/blocks/centrifugeBlock.png");
	
	public static void bindCentrifugeBlock(){
		Minecraft.getMinecraft().getTextureManager().bindTexture(resource);
	}
	
	
	

}
